function [Mxe,Nxe] = bfor_endogenous_ms_solver_matrices_xe(nderivs, Pmatss, H, G, G2)
% 
% Returns the matrices Mxe and Nxe for solving the second order derivative
%   with respect to xlag, epsilon
% 
% Updated 2020/12
% Benigno, Foerster, Otrok, and Rebucci
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %
% 
%  INPUTS
%  nderivs  = structure with elements of the first and second derivatives
%               of f with respect to vars, and first derivatives of Pmat
%               with respect to vars; both evaluated at steady state  

%  Pmatss   = (ns x ns) matrix of the transition matrix at steady state
%  H        = (nx x (nx+ne+1) x ns) array for first-order solution for the 
%               predetermined variables, H(i,j,s) is the response of x(i) 
%               to state(j) given regime s, state=[xlag;epsilon;chi]
%  G        = (ny x (nx+ne+1) x ns) array for first-order solution for the 
%               non-predetermined variables, G(i,j,s) is the response of 
%               y(i) to state(j) given regime s, state=[xlag;epsilon;chi]
%  G2       = (ny x (nx+ne+1)^2 x ns) array for second-order solution for 
%               the non-predetermined variables, G2(i,j,s) is the response 
%               of y(i) to the j-element of kron(state,state) conditional 
%               on regime s
%  
%  OUTPUTS
%   Mxe     = {ns x ns) cell of derivative coefficients for solving the
%               system
%   Nxe     = {ns x ns) cell of constants for solving the system
% 
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %
% -- Other Setup -- %
ny  = size(G,1);
nx  = size(H,1);
ne  = size(H,2)-nx-1;
ns  = length(Pmatss);
n = nx + ny;
Mxe = cell(ns,ns);
Nxe = cell(ns,ns);

dPy = nderivs.dPy;

for s = 1:ns
    for sp = 1:ns
        dfyp          = nderivs.dfyp{sp,s};
        dfy           = nderivs.dfy{sp,s};
        dfx           = nderivs.dfx{sp,s};
        dfxlag        = nderivs.dfxlag{sp,s};
        dfe           = nderivs.dfe{sp,s};
        dfypyp        = nderivs.dfypyp{sp,s};
        dfypy         = nderivs.dfypy{sp,s};
        dfypx         = nderivs.dfypx{sp,s};
        dfypxlag      = nderivs.dfypxlag{sp,s};
        dfype         = nderivs.dfype{sp,s};
        dfyy          = nderivs.dfyy{sp,s};
        dfyx          = nderivs.dfyx{sp,s};
        dfyxlag       = nderivs.dfyxlag{sp,s};
        dfye          = nderivs.dfye{sp,s};
        dfxx          = nderivs.dfxx{sp,s};
        dfxxlag       = nderivs.dfxxlag{sp,s};
        dfxe          = nderivs.dfxe{sp,s};
        dfxlage       = nderivs.dfxlage{sp,s};
        
        
        Mxe{sp,s} = Pmatss(s,sp)*[kron(eye(nx*ne),dfx+dfyp*G(:,1:nx,sp)) kron(eye(nx*ne),dfy)];
        Nxe{sp,s} = zeros(n*nx*ne,1);
        for bb = 1:nx
            for cc = 1:ne
                for aa = 1:n
                    loc = (bb-1)*n*ne + (cc-1)*n + aa;
                    Nxe{sp,s}(loc) = 0;          
                    for ii = 1:ny  
                        Nxe{sp,s}(loc) = Nxe{sp,s}(loc) ...
                            + Pmatss(s,sp)*(reshape(dfypyp(aa,ii,:),1,[])*G(:,1:nx,sp)*H(:,nx+cc,s) + reshape(dfypy(aa,ii,:),1,[])*G(:,nx+cc,s) + reshape(dfypx(aa,ii,:),1,[])*H(:,nx+cc,s) + reshape(dfype(aa,ii,cc),1,[]))*G(ii,1:nx,sp)*H(:,bb,s) ...
                            + Pmatss(s,sp)*(reshape(dfypy(aa,:,ii),1,[])*G(:,1:nx,sp)*H(:,nx+cc,s)  + reshape(dfyy(aa,ii,:),1,[])*G(:,nx+cc,s)  + reshape(dfyx(aa,ii,:),1,[])*H(:,nx+cc,s)  + reshape(dfye(aa,ii,cc),1,[]))*G(ii,bb,s);
                    end
                    for ii = 1:nx
                       Nxe{sp,s}(loc) = Nxe{sp,s}(loc) ...
                           + Pmatss(s,sp)*(reshape(dfypx(aa,:,ii),1,[])*G(:,1:nx,sp)*H(:,nx+cc,s) + reshape(dfyx(aa,:,ii),1,[])*G(:,nx+cc,s) + reshape(dfxx(aa,:,ii),1,[])*H(:,nx+cc,s) + reshape(dfxe(aa,ii,cc),1,[]))*H(ii,bb,s) ...
                           + Pmatss(s,sp)*(dfyp(aa,:)*G2(:,(ii-1)*(nx+ne+1)+1:(ii-1)*(nx+ne+1)+nx,sp)*H(ii,bb,s)*H(:,nx+cc,s));
                    end
                    Nxe{sp,s}(loc) = Nxe{sp,s}(loc) ...
                        + Pmatss(s,sp)*(reshape(dfypxlag(aa,:,bb),1,[])*G(:,1:nx,sp)*H(:,nx+cc,s) + dfyxlag(aa,:,bb)*G(:,nx+cc,s) + dfxxlag(aa,:,bb)*H(:,nx+cc,s) + dfxlage(aa,bb,cc)) ...
                        + shiftdim(dPy(s,sp,:),1)*G(:,nx+cc,s)*(dfyp(aa,:)*G(:,1:nx,sp)*H(:,bb,s) + dfy(aa,:)*G(:,bb,s) + dfx(aa,:)*H(:,bb,s) + dfxlag(aa,bb)) ...
                        + shiftdim(dPy(s,sp,:),1)*G(:,bb,s)*(dfyp(aa,:)*G(:,1:nx,sp)*H(:,nx+cc,s) + dfy(aa,:)*G(:,nx+cc,s) + dfx(aa,:)*H(:,nx+cc,s) + dfe(aa,cc));
                end
            end
        end    
    end
end